  ;  HVGLIB.H (formally called ballyequ.h)
  ;  Version 2.6 - March 2, 2004
  ;  Bally Astrocade Equates and Macros Header File
  ; 
  ;  Retyped and proofread by Adam Trionfo and Lance F. Squire
  ;  Version 1.0 (as ballyequ.h) - January 17, 2002
  ;  Version 2.52 (Version 1.0 of HVGLIB.H) - March 28, 2003
  ;    This file contains the equates and macros that Bally
  ;  programs require for assembly.  This file has been
  ;  written to assemble with ZMAC 1.3 (a freely distribut- 
  ;  able Z-80 assembler (with C source), that has a 25-year
  ;  history. ZMAC can be compiled under just about any O.S.
  ;  in existence, so try it out.  This file will probably
  ;  require changes to be assembled under other assemblers.
  ;  
  ;  To assemble your Z-80 source code using ZMAC:
  ;  
  ;  zmac -d -o <outfile> -x <listfile> <filename>
  ;  
  ;  For example, assemble this Astrocade Z-80 ROM file:
  ;     
  ;  zmac -d -o BallyROM.bin -x BallyROM.lst BallyROM.asm
  ;
  ;    Currently the Listing file is full of 'Undeclared'
  ;  errors.  When all of the source is typed-in, these will
  ;  vanish. I'm leaving the others until all the source is
  ;  re-typed. 
  ;
  EJECT     ; The next line is 30, always keep it there
  ; ***************************
  ; * HOME VIDEO GAME EQUATES *
  ; ***************************
  ;
  ;  ASSEMBLY CONTROL
  ;
XPNDON  EQU    1          ; ** SET TO 1 WHEN HARDWARE EXP
NWHDWR  EQU    1          ; ** SET TO 1 WHEN NEW HARDWARE
  ;
  ;  GENERAL GOODIES
NORMEM  EQU    $4000
FIRSTC  EQU    $2000      ; FIRST ADDRESS IN CARTRIDGE
SCREEN  EQU    0
BYTEPL  EQU    40         ; BYTES PER LINE
BITSPL  EQU    160        ; BITS PER LINE
  ;  STUFF IN SYSTEM DOPE VECTOR
STIMER  EQU    $200       ; SECONDS AND GAME TIME,MUSIC
CTIMER  EQU    $203       ; CUSTOM TIMERS
FNTSYS  EQU    $206       ; SYSTEM FONT DESCRIPTOR
FNTSML  EQU    $20D       ; SMALL FONT DESCRIPTOR
ALKEYS  EQU    $214       ; KEYMASK OF ALL KEYS 
MENUST  EQU    $218       ; HEAD OF ONBOARD MENU
MXSCR   EQU    $21E       ; ADDRESS OF 'MAX SCORE' 
NOPLAY  EQU    $228       ; ADDRESS OF '# OF PLAYERS' 
NOGAME  EQU    $235       ; ADDRESS OF '# OF GAMES'
  ;  BITS IN PROCESSOR FLAG BYTE
PSWSGN  EQU    7          ; SIGN BIT 
PSWZRO  EQU    6          ; ZERO BIT  
PSWPV   EQU    2          ; PARITY        OVERFLOW
PSWCY   EQU    0          ; CARRY 
  ;  BITS IN GAME STATUS BYTE
GSBTIM  EQU    0
GSBSCR  EQU    1
GSBEND  EQU    7
  ;  STANDARD VECTOR DISPLACEMENTS AND BITS
VBMR    EQU    0          ; MAGIC REGISTER
VBSTAT  EQU    1          ; STATUS
VBTIMB  EQU    2          ; TIME BASE  
VBDXL   EQU    3          ; DELTA X LO
VBDXH   EQU    4          ; DELTA X HI
VBXL    EQU    5          ; X COORD LO
VBXH    EQU    6          ; X COORD HI
VBXCHK  EQU    7          ; X CHECK FLAGS
VBDYL   EQU    8          ; DELTA Y LO  
VBDYH   EQU    $09        ; DELTA Y HI  
VBYL    EQU    $0A        ; Y COORD LO
VBYH    EQU    $0B        ; Y COORD HI
VBYCHK  EQU    $0C        ; Y CHECK FLAGS
VBOAL   EQU    $0D        ; OLD ADDRESS OF L.O. 
VBOAH   EQU    $0E        ; OLD ADDRESS OF H.O.
  ;  DISPLACEMENTS FROM START OF COORDINATE AREA
VBDCL   EQU    0          ; LO DELTA 
VBDCH   EQU    1          ; HI DELTA
VBCL    EQU    2          ; LO COORD
VBCH    EQU    3          ; HI COORD
VBCCHK  EQU    4          ; CHECK BITS
  ;  BITS IN STATUS BYTE
VBSACT  EQU    7          ; VECTOR ACTIVE STATUS
VBBLNK  EQU    6          ; BLANK STATUS
  ;  BITS IN CHECK BIT MASK
VBCLMT  EQU    0          ; DO LIMIT CHECKING
VBCREV  EQU    1          ; REVERSE DELTA ON LIMIT ATTAIN
VBCLAT  EQU    3          ; COORDINATE IS AT LIMIT
  ;  FONT TABLE DISPLACEMENTS FOR NEW CHARACTER DISPLAY ROU
FTBASE  EQU    0          ; BASE CHARACTER
FTFSX   EQU    1          ; X FRAME SIZE
FTFSY   EQU    2          ; Y FRAME SIZE  
FTBYTE  EQU    3          ; X SIZE FOR CHAR IN BYTES
FTYSIZ  EQU    4          ; Y SIZE IN BITS
FTPTL   EQU    5          ; PATTERN TABLE ADDRESS LO
FTPTH   EQU    6          ; PATTERN TABLE ADDRESS HI
  ;  BITS FOR MAGIC REGISTER     WRITE OPTION BYTE
MRFLOP  EQU    6          ; WRITE WITH FLOP
MRXOR   EQU    5          ; WRITE WITH EXCLUSIVE OR
MROR    EQU    4          ; WRITE WITH OR
MRXPND  EQU    3          ; WRITE WITH EXPAND
MRROT   EQU    2          ; WRITE WITH ROTATE
MRSHFT  EQU    $03        ; MASK OF SHIFT AMOUNT
  ;  BITS OF CONTROL HANDLE INPUT PORT
CHTRIG  EQU    4          ; TRIGGER  
CHRIGH  EQU    3          ; JOYSTICK RIGHT 
CHLEFT  EQU    2          ; JOYSTICK LEFT
CHDOWN  EQU    1          ; DOWN
CHUP    EQU    0          ; UP
  ; CONTEXT BLOCK REGISTER DISPLACEMENTS
CBIYL   EQU    0          ; IY
CBIYH   EQU    1
CBIXL   EQU    2          ; IX
CBIXH   EQU    3 
CBE     EQU    4          ; DE
CBD     EQU    5
CBC     EQU    6          ; BC
CBB     EQU    7 
CBFLAG  EQU    8          ; AF
CBA     EQU    9
CBL     EQU    $0A        ; HL
CBH     EQU    $0B
  ;  SENTRY RETURN CODES EQUATES:
SNUL    EQU    0          ; NOTHING HAPPENED
SCT0    EQU    1          ; COUNTER-TIMER 1 THRU 8
SCT1    EQU    2
SCT2    EQU    3
SCT3    EQU    4
SCT4    EQU    5
SCT5    EQU    6
SCT6    EQU    7
SCT7    EQU    8
SF0     EQU    9          ; FLAG BIT 0
SF1     EQU    $0A
SF2     EQU    $0B
SF3     EQU    $0C
SF4     EQU    $0D
SF5     EQU    $0E
SF6     EQU    $0F
SF7     EQU    $10
SSEC    EQU    $11        ; SECONDS TIMER HAS COUNTED DOWN
SKYD    EQU    $13        ; KEY IS DOWN
SKYU    EQU    $12        ; YES IS UP
SP0     EQU    $1C        ; POT IS 0
SP1     EQU    $1D        ; POT IS 1
SP2     EQU    $1E        ; POT IS 2
SP3     EQU    $1F        ; POT IS 3
ST0     EQU    $14        ; TRIGGER 0
SJ0     EQU    $15        ; JOYSTICK 0
ST1     EQU    $16        ; SIMILARLY FOR 1-3
SJ1     EQU    $17
ST2     EQU    $18
SJ2     EQU    $19
ST3     EQU    $1A
SJ3     EQU    $1B
EJECT 
  ; ********************************
  ; * HOME VIDEO GAME PORT EQUATES *
  ; ********************************
  ; OUTPUT PORTS FOR VIRTUAL COLOR
COL0R   EQU    0          ; COLOR 0 RIGHT
COL1R   EQU    1          ; COLOR 1 RIGHT
COL2R   EQU    2          ; COLOR 2 RIGHT
COL3R   EQU    3          ; COLOR 3 RIGHT
COL0L   EQU    4          ; COLOR 0 LEFT
COL1L   EQU    5          ; COLOR 1 LEFT
COL2L   EQU    6          ; COLOR 2 LEFT   
COL3L   EQU    7          ; COLOR 3 LEFT 
COLBX   EQU    $0B        ; COLOR BLOCK OUTPUT PORT
HORCB   EQU    9          ; HORIZONTAL COLOR BOUNDARY
VERBL   EQU    $0A        ; VERTICAL BLANKING LINE
  ; OUTPUT PORTS FOR MUSIC AND SOUNDS
TONMO   EQU    $10        ; TONE MASTER OSCILLATOR
TONEA   EQU    $11        ; TONE A OSC.
TONEB   EQU    $12        ; TONE B OSC.
TONEC   EQU    $13        ; TONE C OSC.
VIBRA   EQU    $14        ; VIBRATO
VOLAB   EQU    $16        ; TONES A,B VOLUME
VOLC    EQU    $15        ; TONE C VOLUME
VOLN    EQU    $17        ; NOISE VOLUME
SNDBX   EQU    $18        ; SOUND BLOCK OUTPUT PORT
  ; INTERRUPT AND CONTROL OUTPUT PORTS
INFBK   EQU    $0D        ; INTERRUPT FEEDBACK
INMOD   EQU    $0E        ; INTERRUPT MODE
INLIN   EQU    $0F        ; INTERRUPT LINE
CONCM   EQU    8          ; CONSUMER      COMMERCIAL
MAGIC   EQU    $0C        ; MAGIC REGISTER
XPAND   EQU    $19        ; EXPANDER PIXEL DEFINITION PORT
  ; INTERRUPT AND INTERCEPT INPUT PORTS
INTST   EQU    8          ; INTERCEPT STATUS
VERAF   EQU    $0E        ; VERTICAL ADDRESS FEEDBACK
HORAF   EQU    $0F        ; HORIZONTAL ADDRESS FEEDBACK
  ; HAND CONTROL INPUT PORTS
SW0     EQU    $10        ; PLAYER 0 HAND CONTROL
SW1     EQU    $11        ; PLAYER 1 HAND CONTROL
SW2     EQU    $12        ; PLAYER 2 HAND CONTROL
SW3     EQU    $13        ; PLAYER 3 HAND CONTROL
POT0    EQU    $1C        ; PLAYER 0 POT
POT1    EQU    $1D        ; PLAYER 1 POT
POT2    EQU    $1E        ; PLAYER 2 POT
POT3    EQU    $1F        ; PLAYER 3 POT
  ; KEYBOARD INPUT PORTS
KEY0    EQU    $14        ; KEYBOARD COLUMN 0
KEY1    EQU    $15        ; KEYBOARD COLUMN 1
KEY2    EQU    $16        ; KEYBOARD COLUMN 2
KEY3    EQU    $17        ; KEYBOARD COLUMN 3
EJECT 
  ; ***************************************
  ; * HOME VIDEO GAME SYSTEM CALL INDEXES *
  ; ***************************************
  ; USER PROGRAM INTERFACE
UPISTR  EQU    0
INTPC   EQU    UPISTR     ; INTERPRET WITH CONTEXT CREATE
XINTC   EQU    INTPC+2    ; EXIT INTERPRETER WITH CONTEXT
RCALL   EQU    XINTC+2    ; CALL ASM LANGUAGE SUBROUTINE
MCALL   EQU    RCALL+2    ; CALL INTERPRETER SUBROUTINE 
MRET    EQU    MCALL+2    ; RETURN FROM INTERPRETER SUBRO
MJUMP   EQU    MRET+2     ; MACRO JUMP
SUCK    EQU    MJUMP+2    ; SUCK INLINE ARGS INTO CB
  ; SCHEDULER ROUTINES
SCHEDR  EQU    SUCK
ACTINT  EQU    SCHEDR+2   ; SET SUB TIMER
DECCTS  EQU    ACTINT+2   ; DEC CT'S UNDER MASK
  ; MUSIC AND SOUNDS
MUZAK   EQU    DECCTS+2
BMUSIC  EQU    MUZAK      ; BEGIN PLAYING MUSIC
EMUSIC  EQU    BMUSIC+2   ; STOP PLAYING MUSIC
  ; SCREEN HANDLER ROUTINES
SCRSTR  EQU    EMUSIC+2
SETOUT  EQU    SCRSTR     ; SET SCREEN SIZE
COLSET  EQU    SETOUT+2   ; SET COLORS
FILL    EQU    COLSET+2   ; FILL MEMORY WITH DAT
RECTAN  EQU    FILL+2     ; PAINT RECTANGLE
VWRITR  EQU    RECTAN+2   ; WRITE RELATIVE FROM VECTOR
WRITR   EQU    VWRITR+2   ; WRITE RELATIVE
WRITP   EQU    WRITR+2    ; WRITE WITH PATTERN SIZE LOOKUP
WRIT    EQU    WRITP+2    ; WRITE WITH SIZES PROVIDED
WRITA   EQU    WRIT+2     ; WRITE ABSOLUTE
VBLANK  EQU    WRITA+2    ; BLANK AREA FROM VECTOR
BLANK   EQU    VBLANK+2   ; BLANK AREA
SAVE    EQU    BLANK+2    ; SAVE AREA
RESTOR  EQU    SAVE+2     ; RESTORE AREA
SCROLL  EQU    RESTOR+2   ; SCROLL AREA OF SCREEN
  ;
CHRDIS  EQU    SCROLL+2   ; NEW DISPLAY CHARACTER
STRDIS  EQU    CHRDIS+2   ; NEW DISPLAY STRING
DISNUM  EQU    STRDIS+2   ; DISPLAY NUMBER
  ;
RELABS  EQU    DISNUM+2   ; RELATIVE TO ABSOLUTE CONVERSI
RELAB1  EQU    RELABS+2   ; NONMAGIC RELABS
VECTC   EQU    RELAB1+2   ; VECTOR SINGLE COORDINATE
VECT    EQU    VECTC+2    ; VECTOR COORDINATE PAIR
  ; HUMAN INTERFACE ROUTINES
HUMANR  EQU    VECT +2
KCTASC  EQU    HUMANR     ; KEY CODE TO ASCII
SENTRY  EQU    KCTASC+2   ; SENSE TRANSITION
DOIT    EQU    SENTRY+2   ; BRANCH TO TRANSITION HANDLER
DOITB   EQU    DOIT+2     ; USE B INSTEAD OF A
PIZBRK  EQU    DOITB+2    ; TAKE A BREAK
MENU    EQU    PIZBRK+2   ; DISPLAY A MENU
GETPAR  EQU    MENU+2     ; GET GAME PARAMENTER FROM USER
GETNUM  EQU    GETPAR+2   ; GET NUMBER FROM USER
PAWS    EQU    GETNUM+2   ; PAUSE
DISTIM  EQU    PAWS+2     ; DISPLAY TIME
INCSCR  EQU    DISTIM+2   ; INC SCORE
  ; MATH ROUTINES
MATH    EQU    INCSCR+2
INDEXN  EQU    MATH       ; INDEX NIBBLE
STOREN  EQU    INDEXN+2   ; 
INDEXW  EQU    STOREN+2   ; INDEX WORD
INDEXB  EQU    INDEXW+2   ; INDEX BYTE
MOVE    EQU    INDEXB+2   ; BLOCK TRANSFER
SHIFTU  EQU    MOVE+2     ; SHIFT UP A DIGIT
BCDADD  EQU    SHIFTU+2   ; BCD ADD
BCDSUB  EQU    BCDADD+2   ; BCD SUBTRACT
BCDMUL  EQU    BCDSUB+2   ; BCD MULTIPLY
BCDDIV  EQU    BCDMUL+2   ; BCD DIVIDE
BCDCHS  EQU    BCDDIV+2   ; BCD CHANGE SIGN
BCDNEG  EQU    BCDCHS+2   ; BCD NEGATE
DADD    EQU    BCDNEG+2   ; DECIMAL ADD
DSMG    EQU    DADD+2     ; CONVERT TO SIGN MAGNITUDE
DABS    EQU    DSMG+2     ; DECIMAL ABSOLUTE VALUE
NEGT    EQU    DABS+2     ; NEGATE
RANGED  EQU    NEGT+2     ; RANGED RANDOM NUMBER
QUIT    EQU    RANGED+2   ; QUIT CASSETTE EXECUTION
SETB    EQU    QUIT+2     ; SET BYTE
SETW    EQU    SETB+2     ; SET WORD
MSKTD   EQU    SETW+2     ; MASK TO DELTAS
EJECT 
  ; **********
  ; * MACROS *
  ; **********
  ; MACROS TO DEFINE PATTERNS
DEF2    MACRO  AA, AB
        DB     AA
        DB     AB
        ENDM
DEF3    MACRO  BA, BB, BCC
        DB     BA
        DB     BB
        DB     BCC  ; 'BC' reserved, so used 'BCC'
        ENDM
DEF4    MACRO  CA, CB, CC, CD
        DB     CA
        DB     CB
        DB     CC
        DB     CD
        ENDM
DEF5    MACRO  DA, DBB, DC, DD, DEE
        DB     DA
        DB     DBB
        DB     DC
        DB     DD
        DB     DEE
        ENDM
DEF6    MACRO  EA, EB, EC, ED, EE, EF
        DB     EA
        DB     EB
        DB     EC
        DB     ED
        DB     EE
        DB     EF
        ENDM
DEF8    MACRO  GA, GB, GC, GD, GEE, GF, GG, GH
        DB     GA
        DB     GB
        DB     GC
        DB     GD
        DB     GEE  ; 'GE' reserved, so used 'GEE'
        DB     GF
        DB     GG
        DB     GH 
        ENDM
  ; MACROS TO COMPUTE CONSTANT SCREEN ADDRESSES
XYRELL  MACRO  p1, p2, p3  ; RELATIVE LOAD
        LD     p1,[(p3 SHL 8)+p2]
        ENDM
 ; MACRO TO GENERATE SYSTEM CALL
SYSTEM  MACRO  NUMBA
        RST    56
        DB     NUMBA
        IF     NUMBA = INTPC
INTPCC   DEFL   1
        ENDIF
        ENDM
  ; MACRO TO GENERATE SYSTEM CALL WITH SUCK OPTION ON
SYSSUK  MACRO  UMBA
        RST    56
        DB     UMBA+1
        IF     UMBA = INTPC
INTPCC  DEFL   1
        ENDIF
        ENDM
  ; MACROS TO GENERATE MACRO INSTRUCTION CALLS
  ; FILL SCREEN WITH CONSTANT DATA (was 'FILL?')
FILLq   MACRO  START, NBYTES, DATA
        DB     FILL+1
        DW     START
        DW     NBYTES
        DB     DATA
        ENDM
  ; EXIT INTERPRETER WITH CONTEXT RESTORE
EXIT    MACRO
        DB     XINTC
INTPCC  DEFL   0
        ENDM
  ; INTERPRET WITH INLINE SUCK
DO      MACRO  CID
        DB     CID+1
        ENDM
  ; INTERPRET WITHOUT INLINE SUCK
DONT    MACRO  CID
        DB     CID
        ENDM
  ; MACRO CALL FROM DOIT TABLE
ENDx    EQU    $C0
MC      MACRO  AA, BB, EE
        DB     AA+$80
        DW     BB
        IF     EE = $C0
        DB     EE
        ENDIF
        ENDM
  ; REAL CALL FROM DOIT TABLE
RC      MACRO  AA, BB, EE
        DB     AA+$40
        DW     BB
        IF     EE = $C0
        DB     EE
        ENDIF
        ENDM
  ; REAL JUMP FROM DOIT TABLE
JMPd    MACRO  AA, BB, EE
        DB     AA
        DW     BB
        IF     EE = $C0
        DB     EE
        ENDIF
        ENDM
  ; DISPLAY A STRING
TEXTD   MACRO  AA, BB, CC, DD
        DB     STRDIS+1
        DB     BB
        DB     CC
        DB     DD
        DW     AA
        ENDM
Space 4                   
  ;**************
  ; MUSIC MACROS
  ; NOTE DURATION, FREQ(S)
NOTE1   MACRO  DUR, N1
        DB     (DUR)&($7F)
        DB     N1
        ENDM
NOTE2   MACRO  DUR, N1, N2
        DB     (DUR)&($7F)
        DB     N1
        DB     N2
        ENDM
NOTE3   MACRO  DUR, N1, N2, N3
        DB     DUR
        DB     N1
        DB     N2
        DB     N3
        ENDM
NOTE4   MACRO  DUR, N1, N2, N3, N4
        DB     DUR
        DB     N1
        DB     N2
        DB     N3
        DB     N4
        ENDM
NOTE5   MACRO  DUR, N1, N2, N3, N4, N5
        DB     DUR
        DB     N1
        DB     N2
        DB     N3
        DB     N4
        DB     N5
        ENDM
MASTER  MACRO  OFFSET
        DB     $80
        DB     OFFSET
        ENDM
  ; STUFF OUTPUT PORT#, DATA  OR
  ; OUTPUT SNDBX, DATA10, D11,..., DATA17
OUTPUT  MACRO  PORT, D0, D1, D2, D3, D4, D5, D6, D7
;        IF     NOT (PORT=$18)
        IF     PORT!=$18
        DB     $80+((PORT)&($7F))
        DB     D0
        ENDIF
        IF     PORT=$18
        DB     $88
        DEF8   D7, D6 ,D5, D4, D3, D2, D1, D0
        ENDIF
        ENDM
  ; SET VOICE BYTE
  ; THE FORMAT OF THE VOICE BYTE IS
  ; *I*A*I*B*I*C*V*N
  ; WHERE N = LOAD NOISE WITH DATA AT PC AND INC PC
  ; V = LOAD VIBRATO AND INC PC
  ; I = INC PC
  ; A,B,C = LOAD TONE A,B,C WITH DATA AT PC
VOICEM  MACRO  MASK  ;  'VOICES' TO 'VOICEM'
        DB     $90
        DB     MASK
        ENDM
; PUSH NUMBER ONTO STACK
PUSHN   MACRO  NUMB
        DB     $A0+((NUMB-1) AND $F)
        ENDM
  ; SET VOLUMES
VOLUME  MACRO  P1, P2
        DB     $B0
        DB     P1
        DB     P2
        ENDM
; CALL RELATIVE 0-15 BEYOND SELF+1
CREL    MACRO  BY
        DB     $D0+(BY AND $F)
        ENDM
; DEC STACK TOP AND JNZ
DSJNZ   MACRO  ADD_IT
        DB     $C0
        DW     ADD_IT
        ENDM
; FLIP LEGATO  STACATO
LEGSTA  MACRO
        DB     $E0
        ENDM
REST    MACRO  TIME
        DB     $E1
        DB     TIME
        ENDM
QUIET   MACRO
        DB     $F0
        ENDM
  ; *****************
  ; * MUSIC EQUATES *
  ; *****************
  ; NOTE VALUES
G0      EQU    253
GS0     EQU    238
A0      EQU    225
AS0     EQU    212
B0      EQU    200
C1      EQU    189
CS1     EQU    178
D1      EQU    168
DS1     EQU    159
E1      EQU    150
F1      EQU    141
FS1     EQU    133
G1      EQU    126
GS1     EQU    119
A1      EQU    112
AS1     EQU    106
B1      EQU    100
C2      EQU    94
CS2     EQU    89
D2      EQU    84
DS2     EQU    79
E2      EQU    74
F2      EQU    70
FS2     EQU    66
G2      EQU    62
GS2     EQU    59
A2      EQU    55
AS2     EQU    52
B2      EQU    49
C3      EQU    46
CS3     EQU    44
D3      EQU    41
DS3     EQU    39
E3      EQU    37
F3      EQU    34
FS3     EQU    32
G3      EQU    31
GS3     EQU    29
A3      EQU    27
AS3     EQU    26
B3      EQU    24
C4      EQU    23
CS4     EQU    21
D4      EQU    20
DS4     EQU    19
E4      EQU    18
F4      EQU    17
FS4     EQU    16
G4      EQU    15
GS4     EQU    14
A4      EQU    13
C5      EQU    11
CS5     EQU    10
DS5     EQU    9
F5      EQU    8
G5      EQU    7
A5      EQU    6
C6      EQU    5
DS6     EQU    4
G6      EQU    3
C7      EQU    2
G7      EQU    1
G8      EQU    0
  ; MASTER OSCILATOR OFFSETS
OB0     EQU    254
OC0     EQU    241
OD1     EQU    214
OE1     EQU    191
OF1     EQU    180
OG1     EQU    160
OA1     EQU    143
OA2     EQU    71
OA3     EQU    35
OA4     EQU    17
OA5     EQU    8
EJECT 
  ; ***************************
  ; * SYSTEM RAM MEMORY CELLS *
  ; ***************************
WASTE   EQU    0FFFH
WASTER  EQU    WASTE
  ;
  ; THE FOLLOWING ORG SHOULD BE SET TO THE VALUE OF
  ; THE TAG 'SYSRAM', THIS WILL CAUSE SYSTEM RAM
  ; TO RESIDE AT THE HIGEST POSSIBLE ADDRESS
  ;
;        ORG   $4FC8
;        DEFS   6          ; GOT SOME LEFT STILL
BEGRAM  EQU    $4FCE
  ; USED BY MUSIC PROCESSOR
MUZPC   EQU    $4FCE      ; MUSIC PROGRAM COUNTER
MUZSP   EQU    $4FD0      ; MUSIC STACK POINTER
PVOLAB  EQU    $4FD2      ; PRESET VOLUME FOR TONES A AND B
PVOLMC  EQU    $4FD3      ; PRESET VOLUME FOR MASTER OSC
VOICES  EQU    $4FD4      ; MUSIC VOICES
  ; COUNTER TIMERS (USED BY DECCTS,ACTINT,CTIMER)
CT0     EQU    $4FD5      ; COUNTER TIMER 0
CT1     EQU    $4FD6      ; 1
CT2     EQU    $4FD7      ; 2
CT3     EQU    $4FD8      ; 3
CT4     EQU    $4FD9      ; 4
CT5     EQU    $4FDA      ; 5
CT6     EQU    $4FDB      ; 6
CT7     EQU    $4FDC      ; 7
  ;USED BY SENTRY TO TRACK CONTROLS
CNT     EQU    $4FDD      ; COUNTER UPDATE&NUMBER TRACKING
SEMI4S  EQU    $4FDE      ; FLAG BITS
OPOT0   EQU    $4FDF      ; POT 0 TRACKING
OPOT1   EQU    $4FE0      ; POT 1 TRACKING
OPOT2   EQU    $4FE1      ; POT 2 TRACKING
OPOT3   EQU    $4FE2      ; POT 3 TRACKING
KEYSEX  EQU    $4FE3      ; KEYBOARD TRACKING BYTE
OSW0    EQU    $4FE4      ; SWITCH 0 TRACKING
OSW1    EQU    $4FE5      ; SWITCH 1 TRACKING
OSW2    EQU    $4FE6      ; SWITCH 2 TRACKING
OSW3    EQU    $4FE7      ; SWITCH 3 TRACKING
COLLST  EQU    $4FE8      ; COLOR LIST ADDRESS FOR P.B.A
  ; USED BY STIMER
DURAT   EQU    $4FEA      ; NOTE DURATION
TMR60   EQU    $4FEB      ; SIXTIETHS OF SEC
TIMOUT  EQU    $4FEC      ; BLAKOUT TIMER
GTSECS  EQU    $4FED      ; GAME TIME SECONDS
GTMINS  EQU    $4FEE      ; GAME TIME MINUTES
  ; USED BY MENU
RANSHT  EQU    $4FEF      ; RANDOM NUMBER SHIFT REGISTER
NUMPLY  EQU    $4FF3      ; NUMBER OF PLAYERS
ENDSCR  EQU    $4FF4      ; SCORE TO 'PLAY TO'
MRLOCK  EQU    $4FF7      ; MAGIC REGISTER LOCK OUT FLAG
GAMSTB  EQU    $4FF8      ; GAME STATUS BYTE
PRIOR   EQU    $4FF9      ; MUSIC PROTECT FLAG
SENFLG  EQU    $4FFA      ; SENTRY CONTROL SEIZURE FLAG
UMARGT  EQU    $4FFB 
USERTB  EQU    $4FFD 
SYSRAM  EQU    $4FCE
